
PROGRAM _INIT
	instMpAxisBasic.Enable := 1;
	
	instAxisParameters.Velocity := 10.0;     //10mm/s
	instAxisParameters.Acceleration := 50.0; //50mm/s^2
	instAxisParameters.Deceleration := 50.0; //50mm/s^2
	
	instAxisParameters.Homing.Mode := mcHOMING_DEFAULT; //select default Homing method
END_PROGRAM

PROGRAM _CYCLIC
	
	(* got to error state if error happens during operation *)
	IF instMpAxisBasic.Error AND RunState >= 100 THEN
		RunState := 90;
	END_IF;
	
	CASE RunState OF
		0 : (* wait until connection is established *)
			IF instMpAxisBasic.Info.CommunicationReady AND instMpAxisBasic.Active THEN
				IF instMpAxisBasic.Info.ReadyToPowerOn THEN
					RunState := 20; //go to power on
				END_IF;
				IF instMpAxisBasic.Error THEN
					RunState := 10; //error from previous run, go to reset
				END_IF;
			END_IF;
			
		10: (* reset error *)
			instMpAxisBasic.ErrorReset := TRUE;
			RunState := 11;
			
		11:
			IF NOT instMpAxisBasic.Error AND instMpAxisBasic.Info.ReadyToPowerOn THEN
				instMpAxisBasic.ErrorReset := FALSE;
				RunState := 20;
			END_IF;
			
		20: (* power on *)
			instMpAxisBasic.Power := 1;
			RunState := 21;
			
		21:
			IF instMpAxisBasic.PowerOn THEN
				RunState := 30;
			END_IF;
			
		30: (* home axis *)
			IF NOT instMpAxisBasic.IsHomed THEN
				instMpAxisBasic.Home := TRUE;
				RunState := 31;
			ELSE
				RunState := 100;
			END_IF;
			
		31:
			IF instMpAxisBasic.IsHomed THEN
				instMpAxisBasic.Home := FALSE;
				RunState := 100;
			END_IF;
			
		100: (* drive to 30mm *)
			instAxisParameters.Position := 30.0;
			instMpAxisBasic.MoveAbsolute := TRUE;
			RunState := 110;
			
		110:
			IF instMpAxisBasic.MoveDone THEN
				instMpAxisBasic.MoveAbsolute := FALSE;
				RunState := 120;
			END_IF;
			
		120: (* drive to 0mm *)
			instAxisParameters.Position := 0.0;
			instMpAxisBasic.MoveAbsolute := TRUE;
			RunState := 130;
			
		130:
			IF instMpAxisBasic.MoveDone THEN
				instMpAxisBasic.MoveAbsolute := FALSE;
				RunState := 100;
			END_IF;
		
		90:
			(* Insert error handling here *)
			//instMpAxisBasic.ErrorReset := TRUE;
			
			IF NOT instMpAxisBasic.Error THEN
				instMpAxisBasic.Power := FALSE;
				instMpAxisBasic.MoveAbsolute := FALSE;
				instMpAxisBasic.Home := FALSE;
				instMpAxisBasic.ErrorReset := FALSE;
				RunState := 0;
			END_IF;

	END_CASE;
	
	instMpAxisBasic(MpLink := ADR(gAxis_1), Parameters := ADR(instAxisParameters));
	
END_PROGRAM

PROGRAM _EXIT
	(* Insert code here *)
	 
END_PROGRAM

